import { Phone, MessageCircle, HardHat, Ruler, Hammer } from 'lucide-react';

export default function ContractingTemplate({ data }: { data: Record<string, string> }) {
    return (
        <div className="font-sans text-gray-800 bg-white min-h-full" dir="rtl">
            {/* Hero */}
            <header className="relative h-[600px] bg-gray-900 text-white">
                <div className="absolute inset-0 bg-[url('https://images.unsplash.com/photo-1503387762-592deb58ef4e?auto=format&fit=crop&q=80')] bg-cover bg-center opacity-30" />
                <div className="absolute inset-0 bg-gradient-to-r from-black/80 to-transparent" />

                <div className="relative container mx-auto px-4 h-full flex flex-col justify-center">
                    <div className="max-w-2xl border-r-4 border-yellow-500 pr-8">
                        <h1 className="text-5xl font-bold mb-6 leading-tight">{data.heroTitle}</h1>
                        <p className="text-xl text-gray-300 mb-10">{data.heroDescription}</p>
                        <div className="flex gap-4">
                            <a href={`tel:${data.phone}`} className="bg-yellow-500 hover:bg-yellow-400 text-black px-8 py-3 rounded font-bold flex items-center gap-2 transition-colors uppercase tracking-wider">
                                <Phone className="w-5 h-5" />
                                اطلب عرض سعر
                            </a>
                        </div>
                    </div>
                </div>
            </header>

            {/* Services Grid */}
            <section className="py-20 bg-white">
                <div className="container mx-auto px-4">
                    <div className="grid md:grid-cols-3 gap-8 -mt-32 relative z-10">
                        <div className="bg-white p-8 shadow-lg border-b-4 border-yellow-500">
                            <HardHat className="w-12 h-12 text-yellow-500 mb-6" />
                            <h3 className="text-xl font-bold mb-4">مقاولات عامة</h3>
                            <p className="text-gray-600">تنفيذ جميع أعمال البناء والإنشاءات بأعلى معايير الجودة.</p>
                        </div>
                        <div className="bg-white p-8 shadow-lg border-b-4 border-yellow-500">
                            <Ruler className="w-12 h-12 text-yellow-500 mb-6" />
                            <h3 className="text-xl font-bold mb-4">تشطيبات وديكور</h3>
                            <p className="text-gray-600">تشطيبات داخلية وخارجية، دهانات، جبس بورد، وأرضيات.</p>
                        </div>
                        <div className="bg-white p-8 shadow-lg border-b-4 border-yellow-500">
                            <Hammer className="w-12 h-12 text-yellow-500 mb-6" />
                            <h3 className="text-xl font-bold mb-4">ترميم وصيانة</h3>
                            <p className="text-gray-600">إعادة تأهيل المباني القديمة وصيانتها وإصلاح التصدعات.</p>
                        </div>
                    </div>
                </div>
            </section>

            {/* Projects Gallery (Placeholder) */}
            <section className="py-20 bg-gray-100">
                <div className="container mx-auto px-4">
                    <h2 className="text-3xl font-bold text-center mb-12">مشاريعنا</h2>
                    <div className="grid md:grid-cols-2 gap-8">
                        <div className="h-64 bg-gray-300 rounded-lg relative overflow-hidden group">
                            {data.project1 ? (
                                <img src={data.project1} alt="Project 1" className="w-full h-full object-cover transition-transform duration-500 group-hover:scale-110" />
                            ) : (
                                <div className="flex items-center justify-center h-full text-gray-500">صورة المشروع 1</div>
                            )}
                            <div className="absolute inset-0 bg-black/50 flex items-center justify-center opacity-0 group-hover:opacity-100 transition-opacity">
                                <span className="text-white font-bold border border-white px-4 py-2">عرض التفاصيل</span>
                            </div>
                        </div>
                        <div className="h-64 bg-gray-300 rounded-lg relative overflow-hidden group">
                            {data.project2 ? (
                                <img src={data.project2} alt="Project 2" className="w-full h-full object-cover transition-transform duration-500 group-hover:scale-110" />
                            ) : (
                                <div className="flex items-center justify-center h-full text-gray-500">صورة المشروع 2</div>
                            )}
                            <div className="absolute inset-0 bg-black/50 flex items-center justify-center opacity-0 group-hover:opacity-100 transition-opacity">
                                <span className="text-white font-bold border border-white px-4 py-2">عرض التفاصيل</span>
                            </div>
                        </div>
                    </div>
                </div>
            </section>

            {/* Contact Bar */}
            <div className="bg-yellow-500 py-12">
                <div className="container mx-auto px-4 flex flex-col md:flex-row items-center justify-between gap-6">
                    <div>
                        <h2 className="text-2xl font-bold text-black mb-2">هل لديك مشروع؟</h2>
                        <p className="text-black/80">نحن هنا لتحويل رؤيتك إلى واقع. تواصل معنا اليوم.</p>
                    </div>
                    <div className="flex gap-4">
                        <a href={`tel:${data.phone}`} className="bg-black text-white px-8 py-3 rounded font-bold hover:bg-gray-800 transition-colors">
                            {data.phone}
                        </a>
                        <a href={`https://wa.me/${data.whatsapp}`} className="bg-white text-black px-8 py-3 rounded font-bold hover:bg-gray-100 transition-colors">
                            واتساب
                        </a>
                    </div>
                </div>
            </div>
        </div>
    );
}
