import { Phone, MessageCircle, Palette, Layout, Star } from 'lucide-react';

export default function DecorTemplate({ data }: { data: Record<string, string> }) {
    return (
        <div className="font-serif text-gray-800 bg-stone-50 min-h-full" dir="rtl">
            {/* Elegant Header */}
            <header className="py-8 text-center border-b border-stone-200 bg-white">
                <h1 className="text-3xl font-bold text-stone-800 tracking-widest uppercase">{data.companyName}</h1>
            </header>

            {/* Hero */}
            <section className="relative h-[70vh] flex items-center justify-center bg-stone-900 text-white overflow-hidden">
                <div className="absolute inset-0 bg-[url('https://images.unsplash.com/photo-1618221195710-dd6b41faaea6?auto=format&fit=crop&q=80')] bg-cover bg-center opacity-50" />
                <div className="relative z-10 text-center px-4 max-w-4xl mx-auto">
                    <h2 className="text-5xl md:text-7xl font-thin mb-8 leading-tight">{data.heroTitle}</h2>
                    <p className="text-xl md:text-2xl font-light text-stone-200 mb-12">{data.heroDescription}</p>
                    <a href={`https://wa.me/${data.whatsapp}`} className="inline-block border border-white px-10 py-4 text-lg hover:bg-white hover:text-stone-900 transition-all duration-500">
                        احجز استشارتك
                    </a>
                </div>
            </section>

            {/* Portfolio Grid */}
            <section className="py-24 bg-white">
                <div className="container mx-auto px-4">
                    <div className="text-center mb-16">
                        <span className="text-stone-500 uppercase tracking-widest text-sm">أعمالنا</span>
                        <h3 className="text-3xl font-bold mt-2 text-stone-800">معرض الصور</h3>
                    </div>

                    <div className="grid md:grid-cols-3 gap-4">
                        <div className="aspect-[3/4] bg-stone-100 relative group overflow-hidden">
                            {data.portfolio1 ? (
                                <img src={data.portfolio1} alt="Portfolio 1" className="w-full h-full object-cover transition-transform duration-700 group-hover:scale-105" />
                            ) : (
                                <div className="flex items-center justify-center h-full text-stone-400">صورة 1</div>
                            )}
                        </div>
                        <div className="aspect-[3/4] bg-stone-100 relative group overflow-hidden md:mt-12">
                            {data.portfolio2 ? (
                                <img src={data.portfolio2} alt="Portfolio 2" className="w-full h-full object-cover transition-transform duration-700 group-hover:scale-105" />
                            ) : (
                                <div className="flex items-center justify-center h-full text-stone-400">صورة 2</div>
                            )}
                        </div>
                        <div className="aspect-[3/4] bg-stone-100 relative group overflow-hidden">
                            {data.portfolio3 ? (
                                <img src={data.portfolio3} alt="Portfolio 3" className="w-full h-full object-cover transition-transform duration-700 group-hover:scale-105" />
                            ) : (
                                <div className="flex items-center justify-center h-full text-stone-400">صورة 3</div>
                            )}
                        </div>
                    </div>
                </div>
            </section>

            {/* Contact Minimal */}
            <section className="py-24 bg-stone-900 text-stone-300 text-center">
                <div className="container mx-auto px-4">
                    <h2 className="text-4xl font-thin text-white mb-8">لنبدأ رحلة التصميم</h2>
                    <div className="flex justify-center gap-8 text-lg">
                        <a href={`tel:${data.phone}`} className="hover:text-white transition-colors border-b border-transparent hover:border-white pb-1">{data.phone}</a>
                        <span className="text-stone-600">|</span>
                        <a href={`https://wa.me/${data.whatsapp}`} className="hover:text-white transition-colors border-b border-transparent hover:border-white pb-1">واتساب</a>
                    </div>
                </div>
            </section>
        </div>
    );
}
