'use client';

import { Phone, MessageCircle, Trees, Flower2, Droplets } from 'lucide-react';

export default function LandscapingTemplate({ data }: { data: Record<string, string> }) {
    const primaryColor = data.primaryColor || '#16a34a'; // Default green-600

    return (
        <div className="font-sans text-gray-800 bg-white min-h-full" dir="rtl">
            {/* Hero Section */}
            <header className="relative h-[500px] text-white overflow-hidden" style={{ backgroundColor: primaryColor }}>
                {/* Abstract Background Pattern if no image */}
                <div className="absolute inset-0 bg-[url('https://images.unsplash.com/photo-1558904541-efa843a96f01?auto=format&fit=crop&q=80')] bg-cover bg-center opacity-40" />

                {data.heroImage && (
                    <img src={data.heroImage} alt="Hero" className="absolute inset-0 w-full h-full object-cover z-0" />
                )}

                <div className="absolute inset-0 bg-gradient-to-t from-black/80 via-black/40 to-transparent z-10" />

                <div className="relative container mx-auto px-4 h-full flex flex-col justify-center items-center text-center z-20">
                    <h1 className="text-4xl md:text-6xl font-bold mb-6 leading-tight">{data.heroTitle}</h1>
                    <p className="text-lg md:text-2xl max-w-2xl mb-10 text-gray-100">{data.heroDescription}</p>
                    <div className="flex flex-col sm:flex-row gap-4 w-full sm:w-auto">
                        <a
                            href={`tel:${data.phone}`}
                            className="text-white px-8 py-4 rounded-full font-bold flex items-center justify-center gap-2 transition-all transform hover:scale-105 shadow-lg"
                            style={{ backgroundColor: primaryColor, filter: 'brightness(1.1)' }}
                        >
                            <Phone className="w-5 h-5" />
                            اتصل الآن: {data.phone}
                        </a>
                        {data.whatsapp && (
                            <a href={`https://wa.me/${data.whatsapp}`} className="bg-white text-gray-900 hover:bg-gray-100 px-8 py-4 rounded-full font-bold flex items-center justify-center gap-2 transition-all transform hover:scale-105 shadow-lg">
                                <MessageCircle className="w-5 h-5 text-green-500" />
                                واتساب
                            </a>
                        )}
                    </div>
                </div>
            </header>

            {/* Services Section */}
            <section className="py-20 bg-white">
                <div className="container mx-auto px-4">
                    <div className="text-center mb-16">
                        <h2 className="text-3xl md:text-4xl font-bold mb-4" style={{ color: primaryColor }}>خدماتنا المتميزة</h2>
                        <div className="w-24 h-1 mx-auto rounded-full" style={{ backgroundColor: primaryColor }}></div>
                    </div>

                    <div className="grid md:grid-cols-3 gap-8">
                        {/* Service 1 */}
                        <div className="group p-8 bg-gray-50 rounded-2xl hover:text-white transition-all duration-300 border border-gray-100 hover:shadow-xl"
                            style={{ '--hover-color': primaryColor } as React.CSSProperties}
                        >
                            <style jsx>{`
                                .group:hover { background-color: var(--hover-color); }
                                .group:hover h3, .group:hover p { color: white; }
                                .group:hover .icon-bg { background-color: white; color: var(--hover-color); }
                            `}</style>
                            <div className="icon-bg w-14 h-14 bg-gray-200 rounded-full flex items-center justify-center mb-6 transition-colors" style={{ color: primaryColor }}>
                                <Trees className="w-8 h-8" />
                            </div>
                            <h3 className="text-xl font-bold mb-4" style={{ color: primaryColor }}>{data.service1Title}</h3>
                            <p className="text-gray-600 leading-relaxed">{data.service1Desc}</p>
                        </div>

                        {/* Service 2 */}
                        <div className="group p-8 bg-gray-50 rounded-2xl hover:text-white transition-all duration-300 border border-gray-100 hover:shadow-xl"
                            style={{ '--hover-color': primaryColor } as React.CSSProperties}
                        >
                            <div className="icon-bg w-14 h-14 bg-gray-200 rounded-full flex items-center justify-center mb-6 transition-colors" style={{ color: primaryColor }}>
                                <Flower2 className="w-8 h-8" />
                            </div>
                            <h3 className="text-xl font-bold mb-4" style={{ color: primaryColor }}>{data.service2Title}</h3>
                            <p className="text-gray-600 leading-relaxed">{data.service2Desc}</p>
                        </div>

                        {/* Service 3 */}
                        <div className="group p-8 bg-gray-50 rounded-2xl hover:text-white transition-all duration-300 border border-gray-100 hover:shadow-xl"
                            style={{ '--hover-color': primaryColor } as React.CSSProperties}
                        >
                            <div className="icon-bg w-14 h-14 bg-gray-200 rounded-full flex items-center justify-center mb-6 transition-colors" style={{ color: primaryColor }}>
                                <Droplets className="w-8 h-8" />
                            </div>
                            <h3 className="text-xl font-bold mb-4" style={{ color: primaryColor }}>{data.service3Title}</h3>
                            <p className="text-gray-600 leading-relaxed">{data.service3Desc}</p>
                        </div>
                    </div>
                </div>
            </section>

            {/* CTA Section */}
            <section className="py-20 text-white relative overflow-hidden" style={{ backgroundColor: primaryColor }}>
                <div className="absolute inset-0 bg-[url('https://images.unsplash.com/photo-1585320806297-9794b3e4eeae?auto=format&fit=crop&q=80')] bg-cover bg-fixed opacity-10" />
                <div className="container mx-auto px-4 relative z-10 text-center">
                    <h2 className="text-3xl md:text-4xl font-bold mb-8">جاهز لتحويل حديقتك؟</h2>
                    <p className="text-xl text-white/90 mb-10 max-w-2xl mx-auto">تواصل معنا اليوم للحصول على استشارة مجانية وعرض سعر مخصص لمشروعك.</p>
                    <a href={`tel:${data.phone}`} className="inline-flex items-center gap-3 bg-white px-10 py-4 rounded-full font-bold hover:bg-gray-50 transition-colors shadow-lg text-lg" style={{ color: primaryColor }}>
                        <Phone className="w-6 h-6" />
                        اتصل بنا: {data.phone}
                    </a>
                </div>
            </section>

            {/* Footer */}
            <footer className="bg-gray-900 text-gray-400 py-12 border-t border-gray-800">
                <div className="container mx-auto px-4 text-center">
                    <h3 className="text-2xl font-bold text-white mb-4">{data.companyName}</h3>
                    <p className="mb-8">نصنع الجمال في كل زاوية.</p>
                    <div className="flex justify-center gap-6 mb-8">
                        {/* Social icons placeholder */}
                    </div>
                    <p className="text-sm">&copy; {new Date().getFullYear()} {data.companyName}. جميع الحقوق محفوظة.</p>
                </div>
            </footer>
        </div>
    );
}
