import { Phone, MessageCircle, Globe, Users, CheckCircle, FileCheck } from 'lucide-react';

export default function RecruitmentTemplate({ data }: { data: Record<string, string> }) {
    return (
        <div className="font-sans text-gray-800 bg-gray-50 min-h-full" dir="rtl">
            {/* Navbar-like Header */}
            <div className="bg-white shadow-sm py-4">
                <div className="container mx-auto px-4 flex justify-between items-center">
                    <h1 className="text-2xl font-bold text-blue-900">{data.companyName}</h1>
                    <div className="text-sm text-gray-500">
                        {data.licenseNumber && <span>{data.licenseNumber}</span>}
                    </div>
                </div>
            </div>

            {/* Hero */}
            <header className="bg-blue-900 text-white py-20">
                <div className="container mx-auto px-4 flex flex-col md:flex-row items-center gap-12">
                    <div className="flex-1">
                        <h2 className="text-4xl md:text-5xl font-bold mb-6 leading-tight">{data.heroTitle}</h2>
                        <p className="text-lg text-blue-100 mb-8 leading-relaxed">{data.heroDescription}</p>
                        <div className="flex flex-col sm:flex-row gap-4">
                            <a href={`tel:${data.phone}`} className="bg-white text-blue-900 px-8 py-3 rounded-md font-bold hover:bg-gray-100 transition-colors flex items-center justify-center gap-2">
                                <Phone className="w-5 h-5" />
                                اتصل بنا
                            </a>
                            <a href={`https://wa.me/${data.whatsapp}`} className="bg-green-500 text-white px-8 py-3 rounded-md font-bold hover:bg-green-600 transition-colors flex items-center justify-center gap-2">
                                <MessageCircle className="w-5 h-5" />
                                واتساب
                            </a>
                        </div>
                    </div>
                    <div className="flex-1 bg-white/10 p-8 rounded-lg backdrop-blur-sm border border-white/20">
                        <h3 className="text-xl font-bold mb-6 border-b border-white/20 pb-4">لماذا تختارنا؟</h3>
                        <ul className="space-y-4">
                            <li className="flex items-center gap-3">
                                <CheckCircle className="w-6 h-6 text-green-400" />
                                <span>سرعة في الإنجاز وإنهاء الإجراءات</span>
                            </li>
                            <li className="flex items-center gap-3">
                                <CheckCircle className="w-6 h-6 text-green-400" />
                                <span>عمالة مدربة ومؤهلة</span>
                            </li>
                            <li className="flex items-center gap-3">
                                <CheckCircle className="w-6 h-6 text-green-400" />
                                <span>ضمان شامل ومتابعة مستمرة</span>
                            </li>
                        </ul>
                    </div>
                </div>
            </header>

            {/* Countries */}
            <section className="py-16 bg-white">
                <div className="container mx-auto px-4 text-center">
                    <h2 className="text-3xl font-bold text-gray-900 mb-12">دول الاستقدام</h2>
                    <div className="flex flex-wrap justify-center gap-6">
                        {data.countries?.split('-').map((country, i) => (
                            <div key={i} className="bg-gray-50 px-8 py-4 rounded-full shadow-sm border border-gray-200 flex items-center gap-3 hover:bg-blue-50 transition-colors">
                                <Globe className="w-5 h-5 text-blue-600" />
                                <span className="font-bold text-gray-700">{country.trim()}</span>
                            </div>
                        )) || <p>الفلبين - إندونيسيا - كينيا - أوغندا</p>}
                    </div>
                </div>
            </section>

            {/* Steps */}
            <section className="py-16 bg-gray-50">
                <div className="container mx-auto px-4">
                    <h2 className="text-3xl font-bold text-center mb-12 text-gray-900">خطوات الاستقدام</h2>
                    <div className="grid md:grid-cols-4 gap-6 text-center">
                        <div className="bg-white p-6 rounded-lg shadow-sm">
                            <div className="w-12 h-12 bg-blue-100 text-blue-600 rounded-full flex items-center justify-center mx-auto mb-4 font-bold text-xl">1</div>
                            <h3 className="font-bold mb-2">اختيار العمالة</h3>
                            <p className="text-sm text-gray-500">اختر السيرة الذاتية المناسبة</p>
                        </div>
                        <div className="bg-white p-6 rounded-lg shadow-sm">
                            <div className="w-12 h-12 bg-blue-100 text-blue-600 rounded-full flex items-center justify-center mx-auto mb-4 font-bold text-xl">2</div>
                            <h3 className="font-bold mb-2">إصدار التأشيرة</h3>
                            <p className="text-sm text-gray-500">نساعدك في الإجراءات</p>
                        </div>
                        <div className="bg-white p-6 rounded-lg shadow-sm">
                            <div className="w-12 h-12 bg-blue-100 text-blue-600 rounded-full flex items-center justify-center mx-auto mb-4 font-bold text-xl">3</div>
                            <h3 className="font-bold mb-2">التعاقد</h3>
                            <p className="text-sm text-gray-500">توقيع العقود الرسمية</p>
                        </div>
                        <div className="bg-white p-6 rounded-lg shadow-sm">
                            <div className="w-12 h-12 bg-blue-100 text-blue-600 rounded-full flex items-center justify-center mx-auto mb-4 font-bold text-xl">4</div>
                            <h3 className="font-bold mb-2">الوصول</h3>
                            <p className="text-sm text-gray-500">استلام العمالة</p>
                        </div>
                    </div>
                </div>
            </section>

            <footer className="bg-blue-900 text-white py-8 text-center">
                <p>&copy; {new Date().getFullYear()} {data.companyName}. مرخص من وزارة الموارد البشرية.</p>
            </footer>
        </div>
    );
}
