export type FieldType = 'text' | 'textarea' | 'image' | 'tel' | 'email' | 'color';

export interface TemplateField {
  id: string;
  label: string;
  type: FieldType;
  placeholder?: string;
  defaultValue?: string;
  required?: boolean;
}

export interface TemplateConfig {
  id: string;
  name: string;
  description: string;
  thumbnail: string;
  fields: TemplateField[];
}

export interface LandingPageData {
  templateId: string;
  content: Record<string, string>;
}
