#!/bin/bash
# Deployment Script for cPanel with AlmaLinux 8

echo "🚀 Starting deployment to cPanel..."

# 1. Build the application
echo "📦 Building Next.js application..."
npm run build

if [ $? -ne 0 ]; then
    echo "❌ Build failed!"
    exit 1
fi

echo "✅ Build completed successfully!"

# 2. Generate Prisma Client
echo "🔧 Generating Prisma Client..."
npx prisma generate

# 3. Create necessary directories
echo "📁 Creating directories..."
mkdir -p logs

# 4. Set permissions
echo "🔒 Setting permissions..."
chmod +x node_modules/.bin/*

echo "✅ Deployment preparation completed!"
echo ""
echo "Next steps:"
echo "1. Upload files to your cPanel account"
echo "2. Configure environment variables in cPanel"
echo "3. Run database migrations: npx prisma migrate deploy"
echo "4. Start the application using Node.js app manager in cPanel"
echo ""
echo "📖 See DEPLOYMENT.md for detailed instructions"

