import { Phone, MessageCircle, ShieldAlert, Bug, SprayCan } from 'lucide-react';

export default function PestControlTemplate({ data }: { data: Record<string, string> }) {
    return (
        <div className="font-sans text-gray-800 bg-white min-h-full" dir="rtl">
            {/* Urgent Header */}
            <div className="bg-red-600 text-white py-2 text-center font-bold animate-pulse">
                خدمة طوارئ 24 ساعة - اتصل الآن
            </div>

            {/* Hero */}
            <header className="bg-gray-900 text-white py-16">
                <div className="container mx-auto px-4 flex flex-col md:flex-row items-center justify-between gap-8">
                    <div className="max-w-xl">
                        <div className="inline-flex items-center gap-2 bg-red-600/20 text-red-400 px-4 py-1 rounded-full text-sm font-bold mb-6 border border-red-600/30">
                            <ShieldAlert className="w-4 h-4" />
                            حماية مضمونة 100%
                        </div>
                        <h1 className="text-4xl md:text-6xl font-bold mb-6">{data.heroTitle}</h1>
                        <p className="text-xl text-gray-400 mb-8">{data.heroDescription}</p>

                        <div className="bg-gray-800 p-6 rounded-lg border border-gray-700">
                            <p className="text-sm text-gray-400 mb-4">احصل على خصم 20% عند الحجز اليوم</p>
                            <div className="flex gap-4">
                                <a href={`tel:${data.phone}`} className="flex-1 bg-red-600 hover:bg-red-700 text-white py-3 rounded font-bold flex items-center justify-center gap-2 transition-colors">
                                    <Phone className="w-5 h-5" />
                                    {data.phone}
                                </a>
                                <a href={`https://wa.me/${data.whatsapp}`} className="flex-1 bg-green-600 hover:bg-green-700 text-white py-3 rounded font-bold flex items-center justify-center gap-2 transition-colors">
                                    <MessageCircle className="w-5 h-5" />
                                    واتساب
                                </a>
                            </div>
                        </div>
                    </div>

                    <div className="relative">
                        <div className="w-64 h-64 bg-red-600 rounded-full blur-3xl opacity-20 absolute inset-0 animate-pulse"></div>
                        <Bug className="w-64 h-64 text-gray-700 relative z-10" />
                    </div>
                </div>
            </header>

            {/* Guarantee */}
            <section className="py-12 bg-red-50 border-b border-red-100">
                <div className="container mx-auto px-4 text-center">
                    <h2 className="text-2xl font-bold text-red-800 mb-2">ضمان حقيقي وموثق</h2>
                    <p className="text-red-700 text-xl font-bold">{data.guarantee}</p>
                    <p className="text-red-600 mt-2 text-sm">إذا عادت الحشرات، نعود للرش مجاناً</p>
                </div>
            </section>

            {/* Services */}
            <section className="py-16">
                <div className="container mx-auto px-4">
                    <div className="grid md:grid-cols-3 gap-8 text-center">
                        <div className="p-6 border border-gray-200 rounded-lg hover:border-red-500 transition-colors">
                            <Bug className="w-12 h-12 mx-auto mb-4 text-red-600" />
                            <h3 className="font-bold text-xl mb-2">مكافحة الصراصير والنمل</h3>
                            <p className="text-gray-500">جل ومبيدات آمنة بدون رائحة</p>
                        </div>
                        <div className="p-6 border border-gray-200 rounded-lg hover:border-red-500 transition-colors">
                            <SprayCan className="w-12 h-12 mx-auto mb-4 text-red-600" />
                            <h3 className="font-bold text-xl mb-2">مكافحة بق الفراش</h3>
                            <p className="text-gray-500">رش حراري ومبيدات قوية للقضاء التام</p>
                        </div>
                        <div className="p-6 border border-gray-200 rounded-lg hover:border-red-500 transition-colors">
                            <ShieldAlert className="w-12 h-12 mx-auto mb-4 text-red-600" />
                            <h3 className="font-bold text-xl mb-2">مكافحة القوارض</h3>
                            <p className="text-gray-500">مصائد وطعوم حديثة</p>
                        </div>
                    </div>
                </div>
            </section>

            <footer className="bg-gray-900 text-white py-8 text-center">
                <p>&copy; {new Date().getFullYear()} {data.companyName}.</p>
            </footer>
        </div>
    );
}
